 ; Ŀ
 ;   Incend - insert a block on a the end of a line.                       
 ;   Copyright 1999, 2006, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Short - error handler.                                                
 ; 
 (DEFUN SHORT (shk / pos entt enam sublst vall)
  (setvar "snapmode" snapp)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Short end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Incend - put a block on a line.                            
 ;   Argument: Blnam - the block name.                                     
 ;             Pa -    the insertion point                                 
 ;             Scal -  the block insertion scale                           
 ;   Returns the entity name of the line.                                  
 ; 
 (DEFUN INCEND (blnam pa scal / pb ss enam entt ten elv angg)
 ; Ŀ
 ;   Snap the insertion point to the nearest entity.                       
 ; 
  (if (setq pb (osnap pa "near"))                  ; look for a near point
      (setq pa pb))                                ; if one then use it
 ; Ŀ
 ;   Decide which type of entity we are dealing with: a line...            
 ; 
  (cond ((setq ss (ssget pa (list (cons 0 "line"))))
         (setq enam (ssname ss 0))
         (setq entt (entget enam))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (if (<= (distance pa ten) (distance pa elv))
             (progn
                  (setq pa ten)
                  (setq angg (angle elv ten)))
             (progn
                  (setq pa elv)
                  (setq angg (angle ten elv))))
         (setq angg (/ (* angg 180) pi))
         (command "insert" blnam pa scal "" (- angg 270)))
 ; Ŀ
 ;   ...a polyline...                                                      
 ; 
        ((setq ss (ssget pa '((-4 . "<or") (0 . "polyline")
                              (0 . "lwpolyline") (-4 . "or>"))))
         (setq enam (ssname ss 0))
         (setq pb (osnap pa "end"))
         (if (equal pa pb) (setq pa (osnap pa "mid")))
         (setq angg (angle pa pb))
         (setq angg (/ (* angg 180) pi))
         (command "insert" blnam pb scal "" (- angg 270)))
 ; Ŀ
 ;   ...or empty space.                                                    
 ; 
      (t (command "insert" blnam pa scal "" 0)))
 enam)
 ; Ŀ
 ;   Subroutine Incend end.                                                
 ; 

 ; Ŀ
 ;   Incend.                                                               
 ; 
 (DEFUN C:INCEND (/ esav *error* snapp scal blnamp pa)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Reset error handler, attdia, and snap.                                
 ; 
  (setq esav *error*)
  (setq *error* short)
  (setq snapp (getvar "snapmode"))
;  (setvar "snapmode" 0)           ; may be better left on...
  (setvar "attdia" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
 ; Ŀ
 ;   Ask for a block name.                                                 
 ; 
  (if blnam
      (progn
           (setq blnamp (getstring (strcat "Block <" blnam ">: ")))
           (if (/= blnamp "") (setq blnam blnamp)))
      (setq blnam (getstring "Block: ")))
 ; Ŀ
 ;   Get a point.                                                          
 ; 
  (setq pa (getpoint "Line: "))
 ; Ŀ
 ;   Call Incend to place the block.                                       
 ; 
  (incend blnam pa scal)
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (setq *error* esav)
 (princ))
